using System;
using System.Data;
using System.Collections;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using Method = System.Reflection.MethodBase;
//
namespace gov.va.med.vbecs.BOL
{
    #region Header
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> 
		///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
		///</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<Note>
		///The Food and Drug Administration classifies this software as a medical device.  
		///As such, it may not be changed in any way. Modifications to this software may result 
		///in an adulterated medical device under 21CFR820, the use of which is considered to 
		///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
		///the Freedom of information Act requires the implementor to assume total responsibility 
		///for the software, and become a registered manufacturer of a medical device, subject 
		///to FDA regulations
		///</Note>
		///<summary>
		///Create an instance of a BloodType reference object.
		///</summary>
    #endregion

	#region BloodType
    public class BloodType
    {
        DataTable _bloodTypeDataTable;
        DataRow _bloodTypeDataRow;
        
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2429"> 
		///		<ExpectedInput>BloodTestTypeId</ExpectedInput>
		///		<ExpectedOutput>DataTabe with BloodTest info</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2430"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// Create an instance of BloodType based on its "BloodTypeCode".
        /// </summary>
        public BloodType(string  bloodTypeCode)
        {
            LoadFromDataRow(DAL.ReferenceData.GetBloodType(bloodTypeCode));
        }



        /// <summary>
        /// LoadFromDataRow
        /// </summary>
        /// <param name="dataRow">Data row</param>
        protected void LoadFromDataRow(DataRow dataRow)
        {
            _bloodTypeDataTable = dataRow.Table;
            _bloodTypeDataRow = dataRow;
        }


        
		#region Public Properties
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2431"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2435"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// string value containing the blood type code
        /// </summary>
        public string BloodTypeCode
        {
			
            get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.BloodTypeCode))
                {
                    return "";
                }
                return (string)_bloodTypeDataRow[Common.VbecsTables.BloodType.BloodTypeCode];
            }
        }

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2436"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2439"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// string value containing the blood type text
        /// </summary>
        public string BloodTypeText
        {
			
            get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.BloodTypeText))
                {
                    return "";
                }
                return (string)_bloodTypeDataRow[Common.VbecsTables.BloodType.BloodTypeText];
            }
        }
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2446"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>short</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2455"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// short value containing the sort column
        /// </summary>
        public short SortColumn
        {
			
            get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.SortColumn))
                {
                    return 0;
                }
                return (short)_bloodTypeDataRow[Common.VbecsTables.BloodType.SortColumn];
            }
        }
        //		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2456"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2457"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// DateTime value containing the last update date
        /// </summary>
        public DateTime LastUpdateDate
        {
			get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.LastUpdateDate))
                {
                    return System.DateTime.MinValue;
                }
                return (DateTime)_bloodTypeDataRow[Common.VbecsTables.BloodType.LastUpdateDate];
            }
        }
        //		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2466"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2468"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// string value containing the last update user
        /// </summary>
        public string LastUpdateUser
        {
			get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.LastUpdateUser))
                {
                    return "";
                }
                return (string)_bloodTypeDataRow[Common.VbecsTables.BloodType.LastUpdateUser];
            }
        }
       
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2470"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>byte[]</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2471"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        /// <summary>
        /// byte array value containing the row version
        /// </summary>
        public byte[] RowVersion
        {			
            get 
            {
                if (_bloodTypeDataRow.IsNull(Common.VbecsTables.BloodType.RowVersion))
                {
                    return null;
                }
                return (byte[])_bloodTypeDataRow[Common.VbecsTables.BloodType.RowVersion];
            }
        }
				
        //
		#endregion


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2476"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>BloodType object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2477"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets blood type by blood type code
		/// </summary>
		/// <param name="bloodTypeCode"></param>
		/// <returns></returns>
        public static BloodType GetBloodType(string  bloodTypeCode)
        {
            return new BloodType(bloodTypeCode);
        }


    }
	#endregion
}
